#include <stdio.h>
#include <string.h>
#include "fusion-c/header/newTypes.h"
#include "fusion-c/header/vars_msxDos.h"
#include "fusion-c/header/io.h"
#include "fusion-c/header/msx_fusion.h"
#include "fusion-c/header/vdp_sprites.h"
#include "fusion-c/header/VDP_GRAPH1.h"
#include "sprites.h"
//#include "tipos_bombjack.h"

#define dirBaseTablaSpritesPatrones 0x3800
#define dirBaseTablaSpritesAtributo 0x1B00
#define TAM_SpritesPatrones			2048
#define TAM_SpritesAtributo			128
#define Cabecera_Fichero			8
#define Total_Sprites				63

//----------- VARIABLES GLOBALES -----------------
byte tab_sprites_from_fichero[TAM_SpritesPatrones];
//t_Enemigo listaEnemigos[10];	// vector lista de enemigos


/********* DOS ERROR HANDLER ***************/
void errorDOS (unsigned char error) {
	switch (error) {
		case __INTER:	printf ("\n\rInternal error"); break;
		case _NORAM	:	printf ("\n\rNot Enough Memory"); break;
		case __IBDOS:	printf ("\n\rInvalid MSX-DOS Call"); break;
		case __IDRV:	printf ("\n\rInvalid drive"); break;
		case __IFNM:	printf ("\n\rInvalid filename"); break;
		case __IPATH:	printf ("\n\rInvalid pathname"); break;
		case __PLONG:	printf ("\n\rPathname too long"); break;
		case __NOFIL:	printf ("\n\rFile not found"); break;
		case __NODIR:	printf ("\n\rDirectory not found"); break;
		case __DRFUL:	printf ("\n\rRoot directory full"); break;
		case __DKFUL:	printf ("\n\rDisk full"); break;
		case __DUPF:	printf ("\n\rDuplicate filename"); break;
		case __DIRE:	printf ("\n\rInvalid directory move"); break;
		case __FILRO:	printf ("\n\rRead only file"); break;
		case __DINE:	printf ("\n\rDirectory not empty"); break;
		case __IATTR:	printf ("\n\rInvalid attributes"); break;
		case __DOT:		printf ("\n\rInvalid . or .. operation"); break;
		case __SYSX:	printf ("\n\rSystem file exists"); break;
		case __DIRX:	printf ("\n\rDirectory exists"); break;
		case __FILEX:	printf ("\n\rFile exists"); break;
		case __FOPEN:	printf ("\n\rFile already in use"); break;
		case __OV64K:	printf ("\n\rCannot transfer above 64K"); break;
		case __FILE:	printf ("\n\rFile allocation error"); break;
		case __EOF:		printf ("\n\rEnd of file"); break;
		case __ACCV:	printf ("\n\rFile access violation"); break;
		case __IPROC:	printf ("\n\rInvalid process id"); break; 
		case __NHAND:	printf ("\n\rNo spare file handles"); break;
		case __IHAND:	printf ("\n\rInvalid file handle"); break;
		case __NOPEN:	printf ("\n\rFile handle not open"); break;
		case __IDEV:	printf ("\n\rInvalid device operation"); break;
		case __IENV:	printf ("\n\rInvalid environment string"); break;
		case __ELONG:	printf ("\n\rEnvironment string too long"); break;
		case __IDATE:	printf ("\n\rInvalid date"); break;
		case _ITIME:	printf ("\n\rInvalid time"); break;
		case __RAMDX:	printf ("\n\rRAM disk (drive H:) already exists"); break;
		case __NRAMD:	printf ("\n\rRAM disk does not exist"); break;
		case __HDEAD:	printf ("\n\rFile handle has been deleted"); break;
		case __ISBFN:	printf ("\n\rInvalid sub-function number"); break;
	}
}

void crearFichero (char *filename) {
	int file;

	printf("\n\rCreando fichero %s.\n\r", filename);
	Create (filename);
	file=Open(filename, O_WRONLY);
	Write(file, SPRITE_DATA, TAM_SpritesPatrones);
	Close(file);
}

void leerSprites (char *filename) {
	int file;	// Set a file handler variable
	//byte buffer[Cabecera_Fichero];

	file=Open(filename, O_RDONLY);
	printf("\n\rFichero %s abierto.", filename);
	// Se salta la cabecera
	//Read(file, buffer, Cabecera_Fichero);	
	// Leyendo la tabla de patrones	de sprites
	Read(file, tab_sprites_from_fichero, TAM_SpritesPatrones);
	Close(file);
	printf("\n\rFichero %s leido.", filename);
}

void verificarGrabacion (void){
	unsigned int i;	

	// Comparando la version en memoria con la leida
	for (i=0; i<TAM_SpritesPatrones; i++)
		if (tab_sprites_from_fichero[i]!=SPRITE_DATA[i])
			printf ("\n\rError. Patrones no coinciden.");
	printf ("\n\r");

}

void copiarSpritesVRAM (){
	
	byte sprite, siguiente = 0;	
	
	for (sprite=0; sprite<Total_Sprites; sprite++) {		
		SetSpritePattern(sprite, &tab_sprites_from_fichero[siguiente],8);
		//SetSpritePattern(sprite, &SPRITE_DATA[siguiente],8);
		siguiente += 8;
	}

	// Tablas patrones	
//	CopyRamToVram (&tab_sprites_from_fichero[0], dirBaseTablaSpritesPatrones, TAM_SpritesPatrones);
}

void dibujaAvatar(byte plano, byte patron, byte x, byte y) {
	PutSprite (plano,patron,x,y,0x07);		// cabeza, manos, cinturón y pies
	PutSprite (plano+1,patron+4,x,y,0x0F);	// ojos y capa
	PutSprite (plano+2,patron+8,x,y,0x09);	// cuerpo
}

void dibujaEnemigo(byte plano, byte patron, byte x, byte y, byte color) {
	PutSprite (plano,patron,x,y,color);
}

//--- generación de números aleatorios dentro de un intervalo definido ---
char FT_RandomNumber (char a, char b)
{
    char random;
    
    random = rand()%(b-a)+a;  // Random number between a and b-1
    return(random);
}





/***************** MAIN *******************/
void main(void) 
{
	char filename[]="sprites.dat";
	byte x = 256/2;
	byte y = 192/2;
	byte patron=0, plano=0, i;

	Cls();
	//--------- Creación del fichero desde BJloadSC.h -----------
//	crearFichero (filename);
	
	//--------- Leyendo fichero guardado -----------
	leerSprites (filename);
//	verificarGrabacion();
	WaitKey();
	// Mostrando sprites	
	Screen(1);	//2
	SpriteReset();	// inicialización de todos los sprites
	copiarSpritesVRAM();
	Sprite16();		// tamaño de sprites 16x16
	SpriteSmall();	// tamaño de sprites sin ampliar
	SpriteOn();
	// Dibujando avatar
	for (i=0; i<12; i++) {
		dibujaAvatar(plano, patron, x, y);		
		WaitKey();
		patron += 12;
	}
	// Dibujando enemigos
	for (i=0; i<18; i++) {
		dibujaEnemigo(plano+4, patron, x-50, y, 0x0F);		
		WaitKey();
		patron += 4;
	}
	// Dibujando las monedas
	for (i=0; i<10; i++) {
		//dibujaEnemigo(plano+5, patron, x+50, y, 0x0F); // regla del 5 sprite
		dibujaEnemigo(plano+5, patron, x+50, y+50, 0x0F);
		WaitKey();
		patron += 4;
	}


	// Vuelta al MSX-DOS
	Screen (0);
	SetColors(15, 4, 4);	// Colores iniciales
	Exit (0);

}